/*
 * CS 3114 Project 3
 * Author: Kevin Lee
 * Compiler: Eclipse 3.7.0
 * Operating System: Windows 7 x64
 * Date Completed: 11/1/2011
 * 
 * The following program sorts a specified file on disk using
 * heapsort and a buffer pool. The file size must be a multiple
 * of 4096 and comprised of key-value records of 2 bytes each
 * (4 bytes total per record). The buffer pool uses the least
 * recently used scheme and the number of 4096 byte blocks the
 * buffer stores is specified in the command line for this
 * program. A statistics file is also outputted to show the
 * sorted file, cache hits/misses, and disk reads/writes.
 * 
 * On my honor:
 *
 * - I have not used source code obtained from another student,
 * or any other unauthorized source, either modified or
 * unmodified.
 *
 * - All source code and documentation used in my program is
 * either my original work, or was derived by me from the
 * source code published in the textbook for this course.
 *
 * - I have not discussed coding details about this project with
 * anyone other than my partner (in the case of a joint
 * submission), instructor, ACM/UPE tutors or the TAs assigned
 * to this course. I understand that I may discuss the concepts
 * of this program with other students, and that another student
 * may help me debug my program so long as neither of us writes
 * anything during the discussion or modifies any computer file
 * during the discussion. I have violated neither the spirit nor
 * letter of this restriction.
 */

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class heapsort {

	public static void main(String[] args) {
		// Check if correct arguments are supplied
		if (args.length != 3) {
			System.out.println("Usage: heapsort <data-file-name> <numb-buffers> <stat-file-name>");
			return;
		}
		
		// Save file paths and buffer size
		String dataFile = args[0];
		String statFile = args[2];
		int buffSize = Integer.parseInt(args[1]);
		long fileSize = 0;
		
		RandomAccessFile file = null;
		
		// Check if specified buffer size is within acceptable range
		if (buffSize < 1 || buffSize > 20) {
			System.out.println("Specified buffer size must be between 1 and 20");
			return;
		}
		
		// Get the length of the file to sort
		try {
			file = new RandomAccessFile(dataFile, "r");
			fileSize = file.length();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		// Check to make sure file is a multiple of 4096
		if (fileSize % 4 != 0) {
			System.out.println("Input file size must be a multiple of 4096");
			return;
		}
		
		// Create a new buffer and heap sort class
		LRUBuffer buff = new LRUBuffer(dataFile, statFile, buffSize, 4096, 4);
		MaxHeap heap = new MaxHeap(buff, fileSize/4);
		
		// Start sort
		long time1 = System.currentTimeMillis();
		heap.buildheap();
		for (int i = 0; i < fileSize/4; i++) {
			heap.removemax();
		}
		buff.flushBuffer();
		long time2 = System.currentTimeMillis();
		
		// Write sort statistics
		buff.writeStats(time2 - time1);
		
		// Print the first record from each block in the sorted file
		try {
			int column = 1;
			byte[] data = new byte[4];
			ByteBuffer bbuff;
			short key, value;
			for (long i = 0; i < fileSize; i+=4096) {
				file.seek(i);
				file.read(data);
				bbuff = ByteBuffer.wrap(data);
				key = bbuff.getShort();
				value = bbuff.getShort();
				System.out.printf("%05d %05d ", key, value);
				if (column % 8 == 0) {
					System.out.println();
				}
				column++;
			}
			file.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
